/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Dialectizer implements Responder {
	
	private static final String DEFAULT_URL = "http://www.rinkworks.com/dialect/dialectt.cgi";

	private Pattern responsePattern;

	private static final String PATTERN_START = "<br><span class=\"black-18\">'";

	private static final String PATTERN_END = "'</span></h3>";

	private static final String PATTERN = PATTERN_START + "(.*)" + PATTERN_END;

	public Dialectizer() {
		this.responsePattern = Pattern.compile(PATTERN,
				Pattern.CASE_INSENSITIVE);
	}
	
	public String respond(String message) {
		try {
			String query = "?dialect=piglatin&text="
					+ URLEncoder.encode(message, "UTF-8");

			// Create a URL for the desired page
			URL url = new URL(DEFAULT_URL + query);

			// Read all the text returned by the server
			BufferedReader in = new BufferedReader(new InputStreamReader(url
					.openStream()));
			StringBuffer buffer = new StringBuffer();
			String str;
			while ((str = in.readLine()) != null) {
				buffer.append(str);
			}
			in.close();

			return parseUsingRegex(buffer.toString());
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return null;
	}

	private String parseUsingRegex(String response) {
		Matcher matcher = responsePattern.matcher(response);
		if (matcher.find()) {
			return matcher.group(1);
		} else {
			return null;
		}
	}
	
	/**
	 * This is for testing purposes only.
	 */
	public static void main(String[] args) {
		final Responder spider = new Dialectizer();

		System.out.println(spider.respond("this is a test"));
	}
}
