/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

public class PigLatinResponder implements Responder {
	/* (non-Javadoc)
	 * @see sternestmeanings.Translator#translate(java.lang.String)
	 */
	public String respond(String message) {
		String[] tokens = message.split("\\s");

		StringBuffer translated = new StringBuffer();

		for (int i = 0; i < tokens.length; i++) {
			String token = tokens[i];

			final char firstChar = token.charAt(0);

			String prefix = (token.length() == 1) ? token : token.substring(1);

			char character = firstChar;
			if (Character.isUpperCase(firstChar)) {
				character = Character.toLowerCase(firstChar);
				prefix = Character.toUpperCase(prefix.charAt(0))
						+ prefix.substring(1);
			}

			String suffix = getSuffix(firstChar);

			String punctuation = "";
			if (prefix.matches("^.*\\p{Punct}$")) {
				punctuation = prefix.substring(prefix.length() - 1);
				prefix = prefix.substring(0, prefix.length() - 1);
			}
			
			translated.append(prefix + character + suffix + punctuation + " ");
		}

		return translated.toString();
	}

	private String getSuffix(char c) {
		c = Character.toLowerCase(c);

		if (c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u') {
			return "way";
		} else {
			return "ay";
		}
	}
}
