/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;

public class QuoteResponder implements Responder {
	
	private Properties quotes;
	
	private Anagrammer anagrammer = new Anagrammer();

	public QuoteResponder() {
	    quotes = new Properties();
	    try {
	        quotes.load(new FileInputStream("quotes.properties"));
	    } catch (IOException e) {
	    		e.printStackTrace();
	    }
	}
	
	public String respond(String message) {
		Random random = new Random();
		
		int count = Integer.parseInt(quotes.getProperty("count"));
		int rand = random.nextInt(count);
		
		String quote = quotes.getProperty("quotes." + rand);
	
		StringBuffer response = new StringBuffer();
		
		response.append("Quote: \"");
		response.append(quote);
		response.append("\"\n");
		response.append("I say: \"");
		response.append(anagrammer.respond(quote));
		response.append("\"");

		return response.toString();
	}
}
