/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

import java.util.Random;

public class ShortResponder implements Responder {
	
	// Array of responses to short messages
	private static final String[] RESPONSES = {
			"Is that all that you are going to say?",
			"Say something more.",
			"Dude, say something more.",
			"Say something more, dude",
			"Are you monosyllabic?",
			"Blah!",
			"Blah! Blah!",
			"Brevity is not a virtue.",
			"Tell me something more interesting.",
			"I'm bored.",
			"Shit, I'm bored.",
			"Hmmm..."};

	public String respond(String message) {
		Random random = new Random();
		
		int r = random.nextInt(RESPONSES.length);
		
		return ShortResponder.RESPONSES[r];
	}
}
