/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

import com.levelonelabs.aim.AIMClient;
import com.levelonelabs.aim.AIMSender;

/**
 * This is the main application gibber bots using the AIM interface.
 * 
 * @author Ian Li
 */
public class SternestMeanings {
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length != 1) {
			System.out.println("You must have one argument: properties_file");
		} else {
			final String propertiesFilename = args[0];
			Properties properties = new Properties();

			try {
				properties.load(new FileInputStream(propertiesFilename));
			} catch (IOException e) {
				e.printStackTrace();
			}

			final String id = properties.getProperty("aim.id");
			final String password = properties.getProperty("aim.password");
			final String displayName = properties
					.getProperty("aim.displayName");
			final boolean addToBuddyList = true;

			final AIMSender aim = new AIMClient(id, password, displayName,
					addToBuddyList);

			final String responderList = properties
			.getProperty("responderList");
	
			StringTokenizer st = new StringTokenizer(responderList,",",false);
			
			Responder responder;
			if (st.countTokens() == 0) {
				System.out.println("No responders specified. " +
						"Defaulting to DittoResponder.");
				responder = new DittoResponder();
			} else if (st.countTokens() == 1) {
				responder = getResponder(st.nextToken());
			} else {
				AssemblyResponder assembly = new AssemblyResponder();
				while (st.hasMoreTokens()) {
					assembly.addResponder(getResponder(st.nextToken()));
				}
				responder = assembly;
			}

			final GibberAIMBot anagramAIMBot = new GibberAIMBot(id, aim,
					responder);

			aim.addAIMListener(anagramAIMBot);
			aim.signOn();
		}
	}

	public static Responder getResponder(String responderName) {
		responderName = responderName.trim();

		if (responderName.equals("sternestmeanings")) {
			return new SternestMeaningsResponder();
		} else if (responderName.equals("quote")) {
			return new QuoteResponder();
		} else if (responderName.equals("piglatin")) {
			return new PigLatinResponder();
		} else if (responderName.equals("swedishchef")) {
			return new SwedishChefResponder();
		} else if (responderName.equals("ditto")) {
			return new DittoResponder();
		} else {
			return new DittoResponder();
		}
	}
}

