/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

public class SternestMeaningsResponder implements Responder {
	
	private Responder anagrammer = new Anagrammer();
	private Responder shortResponder = new ShortResponder();
	private Responder quoteResponder = new QuoteResponder();
	
	public String respond(String message) {
		String response = "";
		
		if (message.equals("!quote")) {
			response = quoteResponder.respond(message);
		} else {
			response = anagrammer.respond(message);
			
			if (response.length() == 0) {
				if (message.length() < 8) {
					response = shortResponder.respond(message);
				} else {
					response = "hmmm...";
				}
			}
		}
		
		return response;
	}

}
