/*
 *  Copyright (C) 2006 Sternest Meanings
 *	contact@sternestmeanings.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package sternestmeanings;

import java.util.StringTokenizer;

/**
 * This is an implementation of the Swedish Chef translator.
 *  
 * This code is based on Josh Vura-Weis's <wtpooh@leland.stanford.edu>
 * implementation of Encheferizer. He wrote Encheferizer in 1998. This is his
 * description of the code: <blockquote>This class translates English to
 * mock-Swedish a-la the Swedish Chef <br>
 * The translation rules were taken as faithfully as possible from Lex source at
 * <A HREF="ftp://shell5.ba.best.com/pub/tbrowne/swedish_chef/">
 * ftp://shell5.ba.best.com/pub/tbrowne/swedish_chef/</A> Please report any
 * inconsistencies to <A HREF="mailto:wtpooh@leland.stanford.edu">
 * wtpooh@leland.stanford.edu</a></blockquote>
 * 
 * @author Ian Li
 */
public class SwedishChefResponder implements Responder {

	public String respond(String message) {
		StringBuffer buff = new StringBuffer();

		String word = "";
		String delimiters = " \n\t\\,<.>/?;:'\"[{]}|=+-_!@#$%^&*()~`";

		StringTokenizer st = new StringTokenizer(message, delimiters, true);
		while (st.hasMoreTokens()) {
			word = st.nextToken();

			// If it is not a delimiter,
			if (delimiters.indexOf(word) == -1) {
				// Then, translate the word.
				buff.append(translateWord(word));
			} else {
				// Otherwise spit back the delimiter.
				buff.append(word);
			}
		}

		if (word.equals(".")) {
			buff.append(" Bork Bork Bork!");
		}
		
		return buff.toString();
	}

	private String translateWord(String word) {
		if (word.toLowerCase().equals("bork")) {
			return word;
		}

		char letter;
		int count = 0;
		int len = word.length();
		StringBuffer buff = new StringBuffer();

		boolean i_seen = false;

		while (count < len) {
			boolean isLast = count == (len - 1);

			letter = word.charAt(count);

			if (count == 0) { // Beginning-of-word rules
				if (letter == 'e') {
					buff.append("i");
					count++;
					continue;
				} else if (letter == 'E') {
					buff.append("I");
					count++;
					continue;
				} else if (letter == 'o') {
					buff.append("oo");
					count++;
					continue;
				} else if (letter == 'O') {
					buff.append("Oo");
					count++;
					continue;
				}
			} else { // End of Beginning-of-word rules, Start of In-Word
				// rules
				if (letter == 'e') {
					if (!isLast && word.charAt(count + 1) == 'w') {
						buff.append("oo");
						count += 2;
						continue;
					} else if (isLast) {
						buff.append("e-a");
						count++;
						continue;
					}
				} else if (letter == 'f') {
					buff.append("ff");
					count++;
					continue;
				} else if (letter == 'i') {
					if (!isLast && word.charAt(count + 1) == 'r') {
						buff.append("ur");
						count += 2;
						continue;
					} else if (!i_seen) {
						buff.append("ee");
						count++;
						i_seen = true;
						continue;
					}
				} else if (letter == 'o') {
					if (!isLast && word.charAt(count + 1) == 'w') {
						buff.append("oo");
						count += 2;
						continue;
					} else {
						buff.append("u");
						count++;
						continue;
					}
				} else if (count <= len - 4 && letter == 't'
						&& word.charAt(count + 1) == 'i'

						&& word.charAt(count + 2) == 'o'
						&& word.charAt(count + 3) == 'n') {
					buff.append("shun");
					count += 4;
					continue;
				} else if (letter == 'u') {
					buff.append("oo");
					count++;
					continue;
				} else if (letter == 'U') {
					buff.append("Oo");
					count++;
					continue;
				}
			} // end if In-word rules

			// End if Word-placement rules, Start of Anywhere rules

			if (letter == 'A') {
				if (!isLast && word.charAt(count + 1) == 'n') {
					buff.append("Un");
					count = count + 2;
					continue;
				} else if (!isLast && word.charAt(count + 1) == 'u') {
					buff.append("Oo");
					count = count + 2;
					continue;
				} else if (!isLast) {
					buff.append("E");
					count++;
					continue;
				}
			} else if (letter == 'a') {
				if (!isLast && word.charAt(count + 1) == 'n') {
					buff.append("un");
					count = count + 2;
					continue;
				} else if (!isLast && word.charAt(count + 1) == 'u') {
					buff.append("oo");
					count = count + 2;
					continue;
				} else if (!isLast) {
					buff.append("e");
					count++;
					continue;
				}
			} else if (letter == 'e') {
				if (!isLast && word.charAt(count + 1) == 'n'
				&& count == len - 2) {
					buff.append("ee");
					count += 2;
					continue;
				} else if (count > 0) {

				}
			} else if (letter == 't') {
				if (count == len - 2 && word.charAt(count + 1) == 'h') {
					buff.append("t");
					count += 2;
					continue;
				} else if (count <= len - 3 && word.charAt(count + 1) == 'h'
						&& word.charAt(count + 2) == 'e') {
					buff.append("zee");
					count += 3;
					continue;
				}
			} else if (letter == 'T' && count <= len - 3
					&& word.charAt(count + 1) == 'h'
					&& word.charAt(count + 2) == 'e') {
				buff.append("Zee");
				count += 3;
				continue;
			} else if (letter == 'v') {
				buff.append("f");
				count++;
				continue;
			} else if (letter == 'V') {
				buff.append("F");
				count++;
				continue;
			} else if (letter == 'w') {
				buff.append("v");
				count++;
				continue;
			} else if (letter == 'W') {
				buff.append("V");
				count++;
				continue;
			}

			// End of rules. Whatever is left stays itself

			buff.append(letter);
			count++;
		}

		return buff.toString();
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
